"""empty message

Revision ID: ddd30_1121_schema
Revises: ddd30_schema
Create Date: 2018-03-13 15:48:26.620343
"""

# revision identifiers, used by Alembic.
revision = 'ddd30_1121_schema'
down_revision = 'ddd30_schema'

import json

from alembic import op
import sqlalchemy as sa
from sqlalchemy import text
from sqlalchemy.dialects import postgresql

from common.constants import PBOB_CONF, STIX_FILE_SOURCE, RISK_LEVEL

def _get_old_taxii_collections():
    collections_for_import_and_inbox = PBOB_CONF.TAXII.CollectionsForUserImported
    if not isinstance(collections_for_import_and_inbox, list):
        collections_for_import_and_inbox = [collections_for_import_and_inbox]
    collections_for_product_intelligences = PBOB_CONF.TAXII.CollectionsForTrendIOCs
    if not isinstance(collections_for_product_intelligences, list):
        collections_for_product_intelligences = [collections_for_product_intelligences]
    taxii_collections = collections_for_import_and_inbox + collections_for_product_intelligences
    return taxii_collections

def _get_new_taxii_collections():
    collections_for_import_and_inbox = PBOB_CONF.TAXII.CollectionsForUserImported
    if not isinstance(collections_for_import_and_inbox, list):
        collections_for_import_and_inbox = [collections_for_import_and_inbox]
    ollections_for_subscription_feeds = PBOB_CONF.TAXII.CollectionsForFeeds
    if not isinstance(ollections_for_subscription_feeds, list):
        ollections_for_subscription_feeds = [ollections_for_subscription_feeds]
    collections_for_product_intelligences = PBOB_CONF.TAXII.CollectionsForTrendIOCs
    if not isinstance(collections_for_product_intelligences, list):
        collections_for_product_intelligences = [collections_for_product_intelligences]
    taxii_collections = {
        "import_and_inbox": collections_for_import_and_inbox,
        "subscription_feeds": ollections_for_subscription_feeds,
        "product_intelligences": collections_for_product_intelligences
    }
    return json.dumps(taxii_collections)

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column(u'tb_taxii_setting', 'collections')
    op.add_column('tb_taxii_setting', sa.Column('collections', postgresql.JSON(), nullable=True))
    op.execute(text("""
        UPDATE tb_taxii_setting
        SET collections = :collections
    """).bindparams(collections=_get_new_taxii_collections()))
    op.alter_column('tb_taxii_setting', 'collections', nullable=False)
    op.add_column('tb_stix_files', sa.Column('source', sa.Integer(), nullable=True))
    op.execute(text("""
        UPDATE tb_stix_files
        SET source = :source
    """).bindparams(source=STIX_FILE_SOURCE.UI))
    op.alter_column('tb_stix_files', 'source', nullable=False)
    op.create_table('tb_taxii_feeds',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('enabled', sa.Boolean(), nullable=False),
        sa.Column('schedule', postgresql.JSON(), nullable=True),
        sa.Column('profile_name', sa.String(length=64), nullable=False),
        sa.Column('collection', sa.String(length=256), nullable=False),
        sa.Column('config', postgresql.JSON(), nullable=True),
        sa.Column('logon_password', sa.String(), nullable=True),
        sa.Column('client_key_phrase', sa.String(), nullable=True),
        sa.Column('last_run_ts', sa.DateTime(), nullable=True),
        sa.Column('last_updated_ts', sa.DateTime(), nullable=True),
        sa.Column('run_status', sa.Integer(), nullable=False),
        sa.Column('run_error_code', sa.Integer(), nullable=False),
        sa.Column('poll_first_ts', sa.DateTime(), nullable=True),
        sa.Column('poll_last_ts', sa.DateTime(), nullable=True),
        sa.Column('previous_retrieve_days', sa.Integer(), nullable=True),
        sa.Column('previous_collection', sa.String(length=256), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_taxii_feeds')),
        sa.UniqueConstraint('profile_name', name=op.f('uq_tb_taxii_feeds_profile_name'))
    )
    op.add_column('tb_so_blacklist', sa.Column('import_source', sa.Integer(), nullable=True))
    op.add_column('tb_so_whitelist', sa.Column('import_source', sa.Integer(), nullable=True))
    op.add_column('tb_3rd_taxii_send0', sa.Column('risk_level', sa.Integer(), nullable=True))
    op.execute(text("""
        UPDATE tb_3rd_taxii_send0
        SET risk_level = :risk_level
    """).bindparams(risk_level=RISK_LEVEL.HIGH))
    op.alter_column('tb_3rd_taxii_send0', 'risk_level', nullable=False)
    op.add_column('tb_3rd_taxii_send1', sa.Column('risk_level', sa.Integer(), nullable=True))
    op.execute(text("""
        UPDATE tb_3rd_taxii_send1
        SET risk_level = :risk_level
    """).bindparams(risk_level=RISK_LEVEL.HIGH))
    op.alter_column('tb_3rd_taxii_send1', 'risk_level', nullable=False)
    op.add_column('tb_3rd_taxii_send0', sa.Column('expiration_label', sa.String(), nullable=True))
    op.execute(text("""
        UPDATE tb_3rd_taxii_send0
        SET expiration_label = :expiration_label
    """).bindparams(expiration_label=""))
    op.alter_column('tb_3rd_taxii_send0', 'expiration_label', nullable=False)
    op.add_column('tb_3rd_taxii_send1', sa.Column('expiration_label', sa.String(), nullable=True))
    op.execute(text("""
        UPDATE tb_3rd_taxii_send1
        SET expiration_label = :expiration_label
    """).bindparams(expiration_label=""))
    op.alter_column('tb_3rd_taxii_send1', 'expiration_label', nullable=False)
    op.add_column('tb_ioc_data', sa.Column('device_guid', sa.String(length=36), nullable=True))
    op.drop_constraint('pk_tb_3rd_taxii_send0', 'tb_3rd_taxii_send0', type_='primary')
    op.drop_constraint('pk_tb_3rd_taxii_send1', 'tb_3rd_taxii_send1', type_='primary')
    op.create_primary_key('pk_tb_3rd_taxii_send0', 'tb_3rd_taxii_send0', ['data', 'data_type', 'source_type', 'risk_level', 'expiration_label'])
    op.create_primary_key('pk_tb_3rd_taxii_send1', 'tb_3rd_taxii_send1', ['data', 'data_type', 'source_type', 'risk_level', 'expiration_label'])
    op.create_sequence("dddna_log_seq")
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_sequence("dddna_log_seq")
    op.drop_constraint('pk_tb_3rd_taxii_send1', 'tb_3rd_taxii_send1', type_='primary')
    op.drop_constraint('pk_tb_3rd_taxii_send0', 'tb_3rd_taxii_send0', type_='primary')
    op.create_primary_key('pk_tb_3rd_taxii_send1', 'tb_3rd_taxii_send1', ['data', 'data_type', 'source_type', 'last_update_time'])
    op.create_primary_key('pk_tb_3rd_taxii_send0', 'tb_3rd_taxii_send0', ['data', 'data_type', 'source_type', 'last_update_time'])
    op.drop_column('tb_ioc_data', 'device_guid')
    op.drop_column(u'tb_3rd_taxii_send1', 'expiration_label')
    op.drop_column(u'tb_3rd_taxii_send0', 'expiration_label')
    op.drop_column(u'tb_3rd_taxii_send1', 'risk_level')
    op.drop_column(u'tb_3rd_taxii_send0', 'risk_level')
    op.drop_column(u'tb_so_blacklist', 'import_source')
    op.drop_column(u'tb_so_whitelist', 'import_source')
    op.drop_column(u'tb_stix_files', 'source')
    op.drop_column(u'tb_taxii_setting', 'collections')
    op.add_column('tb_taxii_setting', sa.Column('collections', postgresql.ARRAY(sa.String()), nullable=True))
    op.execute(text("""
        UPDATE tb_taxii_setting
        SET collections = :collections
    """).bindparams(collections=_get_old_taxii_collections()))
    op.alter_column('tb_taxii_setting', 'collections', nullable=False)
    op.drop_table('tb_taxii_feeds')
    ### end Alembic commands ###
